/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.IdentityProviderJacksonHelper;
import io.fusionauth.domain.api.IdentityProviderSearchResponse;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.io.IOException;
import java.util.ArrayList;

public class IdentityProviderSearchResponseDeserializer
extends StdDeserializer<IdentityProviderSearchResponse> {
    public IdentityProviderSearchResponseDeserializer() {
        super(IdentityProviderSearchResponse.class);
    }

    public IdentityProviderSearchResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new IdentityProviderSearchResponse());
    }

    public IdentityProviderSearchResponse deserialize(JsonParser p, DeserializationContext ctxt, IdentityProviderSearchResponse resp) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        resp.total = node.at("/total").asLong();
        JsonNode idpNodes = node.at("/identityProviders");
        if (idpNodes != null && idpNodes.isArray()) {
            resp.identityProviders = new ArrayList();
            for (JsonNode idp : idpNodes) {
                IdentityProviderType idpType = IdentityProviderJacksonHelper.extractType(ctxt, p, idp);
                BaseIdentityProvider<?> baseIdp = IdentityProviderJacksonHelper.newIdentityProvider(idpType);
                ((ObjectMapper)p.getCodec()).readerForUpdating(baseIdp).readValue(idp);
                resp.identityProviders.add(baseIdp);
            }
        }
        return resp;
    }
}

