/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import com.inversoft.error.Errors;
import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClientException;
import java.util.function.Supplier;

public class ExceptionDelegate {
    public <T, U> T execute(Supplier<ClientResponse<T, U>> supplier) {
        ClientResponse<T, U> response = supplier.get();
        if (response.wasSuccessful()) {
            return (T)response.successResponse;
        }
        if (response.status == 404) {
            return null;
        }
        if (response.errorResponse != null && response.errorResponse instanceof Errors) {
            throw new FusionAuthClientException((Errors)response.errorResponse);
        }
        if (response.errorResponse != null) {
            throw new FusionAuthClientException("Invalid error response type");
        }
        if (response.exception != null) {
            throw new FusionAuthClientException(response.exception);
        }
        throw new FusionAuthClientException("ClientResponse didn't contain a error response or an exception - strange");
    }
}

